/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.pipeline.common;

import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.lucene.search.BooleanClause;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.common.hash.MurmurHash3;
import org.opensearch.core.common.Strings;
import org.opensearch.index.query.PrefixQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilderVisitor;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.index.query.WildcardQueryBuilder;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.search.pipeline.AbstractProcessor;
import org.opensearch.search.pipeline.Processor;
import org.opensearch.search.pipeline.SearchRequestProcessor;

public class HierarchicalRoutingSearchProcessor
extends AbstractProcessor
implements SearchRequestProcessor {
    public static final String TYPE = "hierarchical_routing_search";
    private final String pathField;
    private final int anchorDepth;
    private final String pathSeparator;
    private final boolean enableAutoDetection;
    private final Pattern pathSeparatorPattern;
    private final Pattern multiSeparatorPattern;

    HierarchicalRoutingSearchProcessor(String tag, String description, boolean ignoreFailure, String pathField, int anchorDepth, String pathSeparator, boolean enableAutoDetection) {
        super(tag, description, ignoreFailure);
        this.pathField = pathField;
        this.anchorDepth = anchorDepth;
        this.pathSeparator = pathSeparator;
        this.enableAutoDetection = enableAutoDetection;
        this.pathSeparatorPattern = Pattern.compile(Pattern.quote(pathSeparator));
        this.multiSeparatorPattern = Pattern.compile(Pattern.quote(pathSeparator) + "{2,}");
    }

    public String getType() {
        return TYPE;
    }

    public SearchRequest processRequest(SearchRequest request) throws Exception {
        if (request.routing() != null && !request.routing().isEmpty()) {
            return request;
        }
        HashSet<String> routingValues = new HashSet<String>();
        if (request.source() != null && request.source().query() != null) {
            PathExtractionVisitor visitor = new PathExtractionVisitor(routingValues);
            request.source().query().visit((QueryBuilderVisitor)visitor);
        }
        if (!routingValues.isEmpty()) {
            HashSet<String> computedRouting = new HashSet<String>();
            for (String path : routingValues) {
                String routingValue = this.computeRoutingValue(path);
                if (routingValue == null) continue;
                computedRouting.add(routingValue);
            }
            if (!computedRouting.isEmpty()) {
                String routing = String.join((CharSequence)",", computedRouting);
                request.routing(routing);
            }
        }
        return request;
    }

    private String extractPrefixFromWildcard(String pattern) {
        if (pattern == null) {
            return null;
        }
        int wildcardIndex = pattern.indexOf(42);
        int questionIndex = pattern.indexOf(63);
        int firstWildcard = -1;
        if (wildcardIndex >= 0) {
            firstWildcard = wildcardIndex;
        }
        if (questionIndex >= 0 && (firstWildcard < 0 || questionIndex < firstWildcard)) {
            firstWildcard = questionIndex;
        }
        if (firstWildcard >= 0) {
            return pattern.substring(0, firstWildcard);
        }
        return pattern;
    }

    private String computeRoutingValue(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            return null;
        }
        String normalizedPath = this.normalizePath(path);
        String[] segments = this.pathSeparatorPattern.split(normalizedPath);
        String anchor = this.extractAnchor(segments, this.anchorDepth);
        byte[] anchorBytes = anchor.getBytes(StandardCharsets.UTF_8);
        long hash = MurmurHash3.hash128((byte[])anchorBytes, (int)0, (int)anchorBytes.length, (long)0L, (MurmurHash3.Hash128)new MurmurHash3.Hash128()).h1;
        return String.valueOf(hash == Long.MIN_VALUE ? 0L : (hash < 0L ? -hash : hash));
    }

    private String normalizePath(String path) {
        String normalized = path.trim();
        while (normalized.startsWith(this.pathSeparator)) {
            normalized = normalized.substring(this.pathSeparator.length());
        }
        while (normalized.endsWith(this.pathSeparator)) {
            normalized = normalized.substring(0, normalized.length() - this.pathSeparator.length());
        }
        normalized = this.multiSeparatorPattern.matcher(normalized).replaceAll(this.pathSeparator);
        return normalized;
    }

    private String extractAnchor(String[] segments, int depth) {
        StringBuilder anchor = new StringBuilder();
        int effectiveDepth = Math.min(depth, segments.length);
        int addedSegments = 0;
        for (int i = 0; i < effectiveDepth && addedSegments < depth; ++i) {
            if (Strings.isNullOrEmpty((String)segments[i])) continue;
            if (addedSegments > 0) {
                anchor.append(this.pathSeparator);
            }
            anchor.append(segments[i]);
            ++addedSegments;
        }
        if (anchor.length() == 0) {
            return "_root";
        }
        return anchor.toString();
    }

    private class PathExtractionVisitor
    implements QueryBuilderVisitor {
        private final Set<String> paths;

        PathExtractionVisitor(Set<String> paths) {
            this.paths = paths;
        }

        public void accept(QueryBuilder qb) {
            String pattern;
            String pathPrefix;
            WildcardQueryBuilder wildcardQuery;
            if (qb instanceof TermQueryBuilder) {
                TermQueryBuilder termQuery = (TermQueryBuilder)qb;
                if (HierarchicalRoutingSearchProcessor.this.pathField.equals(termQuery.fieldName())) {
                    this.paths.add(termQuery.value().toString());
                }
            } else if (qb instanceof TermsQueryBuilder) {
                TermsQueryBuilder termsQuery = (TermsQueryBuilder)qb;
                if (HierarchicalRoutingSearchProcessor.this.pathField.equals(termsQuery.fieldName())) {
                    for (Object value : termsQuery.values()) {
                        this.paths.add(value.toString());
                    }
                }
            } else if (qb instanceof PrefixQueryBuilder) {
                PrefixQueryBuilder prefixQuery = (PrefixQueryBuilder)qb;
                if (HierarchicalRoutingSearchProcessor.this.pathField.equals(prefixQuery.fieldName())) {
                    this.paths.add(prefixQuery.value());
                }
            } else if (qb instanceof WildcardQueryBuilder && HierarchicalRoutingSearchProcessor.this.pathField.equals((wildcardQuery = (WildcardQueryBuilder)qb).fieldName()) && (pathPrefix = HierarchicalRoutingSearchProcessor.this.extractPrefixFromWildcard(pattern = wildcardQuery.value())) != null && !pathPrefix.isEmpty()) {
                this.paths.add(pathPrefix);
            }
        }

        public QueryBuilderVisitor getChildVisitor(BooleanClause.Occur occur) {
            if (occur == BooleanClause.Occur.MUST || occur == BooleanClause.Occur.FILTER) {
                return this;
            }
            return QueryBuilderVisitor.NO_OP_VISITOR;
        }
    }

    public static final class Factory
    implements Processor.Factory<SearchRequestProcessor> {
        public HierarchicalRoutingSearchProcessor create(Map<String, Processor.Factory<SearchRequestProcessor>> processorFactories, String tag, String description, boolean ignoreFailure, Map<String, Object> config, Processor.PipelineContext pipelineContext) throws Exception {
            String pathField = ConfigurationUtils.readStringProperty((String)HierarchicalRoutingSearchProcessor.TYPE, (String)tag, config, (String)"path_field");
            int anchorDepth = ConfigurationUtils.readIntProperty((String)HierarchicalRoutingSearchProcessor.TYPE, (String)tag, config, (String)"anchor_depth", (Integer)2);
            String pathSeparator = ConfigurationUtils.readOptionalStringProperty((String)HierarchicalRoutingSearchProcessor.TYPE, (String)tag, config, (String)"path_separator");
            boolean enableAutoDetection = ConfigurationUtils.readBooleanProperty((String)HierarchicalRoutingSearchProcessor.TYPE, (String)tag, config, (String)"enable_auto_detection", (boolean)true);
            if (pathSeparator == null) {
                pathSeparator = "/";
            }
            if (anchorDepth <= 0) {
                throw ConfigurationUtils.newConfigurationException((String)HierarchicalRoutingSearchProcessor.TYPE, (String)tag, (String)"anchor_depth", (String)"must be greater than 0");
            }
            if (Strings.isNullOrEmpty((String)pathSeparator)) {
                throw ConfigurationUtils.newConfigurationException((String)HierarchicalRoutingSearchProcessor.TYPE, (String)tag, (String)"path_separator", (String)"cannot be null or empty");
            }
            if (Strings.isNullOrEmpty((String)pathField)) {
                throw ConfigurationUtils.newConfigurationException((String)HierarchicalRoutingSearchProcessor.TYPE, (String)tag, (String)"path_field", (String)"cannot be null or empty");
            }
            return new HierarchicalRoutingSearchProcessor(tag, description, ignoreFailure, pathField, anchorDepth, pathSeparator, enableAutoDetection);
        }
    }
}

