/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.client;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.opensearch.action.admin.indices.segments.IndicesSegmentResponse;
import org.opensearch.action.admin.indices.segments.PitSegmentsRequest;
import org.opensearch.action.admin.indices.view.ListViewNamesAction;
import org.opensearch.action.admin.indices.view.SearchViewAction;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkRequestBuilder;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteRequestBuilder;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.explain.ExplainRequest;
import org.opensearch.action.explain.ExplainRequestBuilder;
import org.opensearch.action.explain.ExplainResponse;
import org.opensearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.opensearch.action.fieldcaps.FieldCapabilitiesRequestBuilder;
import org.opensearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetRequestBuilder;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetRequestBuilder;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexRequestBuilder;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.ClearScrollRequest;
import org.opensearch.action.search.ClearScrollRequestBuilder;
import org.opensearch.action.search.ClearScrollResponse;
import org.opensearch.action.search.CreatePitRequest;
import org.opensearch.action.search.CreatePitResponse;
import org.opensearch.action.search.DeletePitRequest;
import org.opensearch.action.search.DeletePitResponse;
import org.opensearch.action.search.GetAllPitNodesRequest;
import org.opensearch.action.search.GetAllPitNodesResponse;
import org.opensearch.action.search.MultiSearchRequest;
import org.opensearch.action.search.MultiSearchRequestBuilder;
import org.opensearch.action.search.MultiSearchResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchRequestBuilder;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.action.search.SearchScrollRequestBuilder;
import org.opensearch.action.termvectors.MultiTermVectorsRequest;
import org.opensearch.action.termvectors.MultiTermVectorsRequestBuilder;
import org.opensearch.action.termvectors.MultiTermVectorsResponse;
import org.opensearch.action.termvectors.TermVectorsRequest;
import org.opensearch.action.termvectors.TermVectorsRequestBuilder;
import org.opensearch.action.termvectors.TermVectorsResponse;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateRequestBuilder;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.common.Nullable;
import org.opensearch.common.action.ActionFuture;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.transport.client.AdminClient;
import org.opensearch.transport.client.OpenSearchClient;

@PublicApi(since="1.0.0")
public interface Client
extends OpenSearchClient,
Releasable {
    public static final Setting<String> CLIENT_TYPE_SETTING_S = new Setting<String>("client.type", "node", s -> {
        switch (s) {
            case "node": 
            case "transport": {
                return s;
            }
        }
        throw new IllegalArgumentException("Can't parse [client.type] must be one of [node, transport]");
    }, Setting.Property.NodeScope);

    public AdminClient admin();

    public ActionFuture<IndexResponse> index(IndexRequest var1);

    public void index(IndexRequest var1, ActionListener<IndexResponse> var2);

    public IndexRequestBuilder prepareIndex();

    public IndexRequestBuilder prepareIndex(String var1);

    public ActionFuture<UpdateResponse> update(UpdateRequest var1);

    public void update(UpdateRequest var1, ActionListener<UpdateResponse> var2);

    public UpdateRequestBuilder prepareUpdate();

    public UpdateRequestBuilder prepareUpdate(String var1, String var2);

    public ActionFuture<DeleteResponse> delete(DeleteRequest var1);

    public void delete(DeleteRequest var1, ActionListener<DeleteResponse> var2);

    public DeleteRequestBuilder prepareDelete();

    public DeleteRequestBuilder prepareDelete(String var1, String var2);

    public ActionFuture<BulkResponse> bulk(BulkRequest var1);

    public void bulk(BulkRequest var1, ActionListener<BulkResponse> var2);

    public BulkRequestBuilder prepareBulk();

    public BulkRequestBuilder prepareBulk(@Nullable String var1);

    public ActionFuture<GetResponse> get(GetRequest var1);

    public void get(GetRequest var1, ActionListener<GetResponse> var2);

    public GetRequestBuilder prepareGet();

    public GetRequestBuilder prepareGet(String var1, String var2);

    public ActionFuture<MultiGetResponse> multiGet(MultiGetRequest var1);

    public void multiGet(MultiGetRequest var1, ActionListener<MultiGetResponse> var2);

    public MultiGetRequestBuilder prepareMultiGet();

    public ActionFuture<SearchResponse> search(SearchRequest var1);

    public void search(SearchRequest var1, ActionListener<SearchResponse> var2);

    public SearchRequestBuilder prepareSearch(String ... var1);

    public SearchRequestBuilder prepareStreamSearch(String ... var1);

    public ActionFuture<SearchResponse> searchScroll(SearchScrollRequest var1);

    public void searchScroll(SearchScrollRequest var1, ActionListener<SearchResponse> var2);

    public SearchScrollRequestBuilder prepareSearchScroll(String var1);

    public void createPit(CreatePitRequest var1, ActionListener<CreatePitResponse> var2);

    public void deletePits(DeletePitRequest var1, ActionListener<DeletePitResponse> var2);

    public void getAllPits(GetAllPitNodesRequest var1, ActionListener<GetAllPitNodesResponse> var2);

    public void pitSegments(PitSegmentsRequest var1, ActionListener<IndicesSegmentResponse> var2);

    public ActionFuture<MultiSearchResponse> multiSearch(MultiSearchRequest var1);

    public void multiSearch(MultiSearchRequest var1, ActionListener<MultiSearchResponse> var2);

    public MultiSearchRequestBuilder prepareMultiSearch();

    public ActionFuture<TermVectorsResponse> termVectors(TermVectorsRequest var1);

    public void termVectors(TermVectorsRequest var1, ActionListener<TermVectorsResponse> var2);

    public TermVectorsRequestBuilder prepareTermVectors();

    public TermVectorsRequestBuilder prepareTermVectors(String var1, String var2);

    public ActionFuture<MultiTermVectorsResponse> multiTermVectors(MultiTermVectorsRequest var1);

    public void multiTermVectors(MultiTermVectorsRequest var1, ActionListener<MultiTermVectorsResponse> var2);

    public MultiTermVectorsRequestBuilder prepareMultiTermVectors();

    public ExplainRequestBuilder prepareExplain(String var1, String var2);

    public ActionFuture<ExplainResponse> explain(ExplainRequest var1);

    public void explain(ExplainRequest var1, ActionListener<ExplainResponse> var2);

    public ClearScrollRequestBuilder prepareClearScroll();

    public ActionFuture<ClearScrollResponse> clearScroll(ClearScrollRequest var1);

    public void clearScroll(ClearScrollRequest var1, ActionListener<ClearScrollResponse> var2);

    public FieldCapabilitiesRequestBuilder prepareFieldCaps(String ... var1);

    public ActionFuture<FieldCapabilitiesResponse> fieldCaps(FieldCapabilitiesRequest var1);

    public void fieldCaps(FieldCapabilitiesRequest var1, ActionListener<FieldCapabilitiesResponse> var2);

    public void searchView(SearchViewAction.Request var1, ActionListener<SearchResponse> var2);

    public ActionFuture<SearchResponse> searchView(SearchViewAction.Request var1);

    public void listViewNames(ListViewNamesAction.Request var1, ActionListener<ListViewNamesAction.Response> var2);

    public ActionFuture<ListViewNamesAction.Response> listViewNames(ListViewNamesAction.Request var1);

    public Settings settings();

    public Client filterWithHeader(Map<String, String> var1);

    default public Client getRemoteClusterClient(String clusterAlias) {
        throw new UnsupportedOperationException("this client doesn't support remote cluster connections");
    }

    default public CompletionStage<IndexResponse> indexAsync(IndexRequest request) {
        CompletableFuture<IndexResponse> future = new CompletableFuture<IndexResponse>();
        this.index(request, (ActionListener<IndexResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<UpdateResponse> updateAsync(UpdateRequest request) {
        CompletableFuture<UpdateResponse> future = new CompletableFuture<UpdateResponse>();
        this.update(request, (ActionListener<UpdateResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<DeleteResponse> deleteAsync(DeleteRequest request) {
        CompletableFuture<DeleteResponse> future = new CompletableFuture<DeleteResponse>();
        this.delete(request, (ActionListener<DeleteResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<BulkResponse> bulkAsync(BulkRequest request) {
        CompletableFuture<BulkResponse> future = new CompletableFuture<BulkResponse>();
        this.bulk(request, (ActionListener<BulkResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<GetResponse> getAsync(GetRequest request) {
        CompletableFuture<GetResponse> future = new CompletableFuture<GetResponse>();
        this.get(request, (ActionListener<GetResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<MultiGetResponse> multiGetAsync(MultiGetRequest request) {
        CompletableFuture<MultiGetResponse> future = new CompletableFuture<MultiGetResponse>();
        this.multiGet(request, (ActionListener<MultiGetResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<SearchResponse> searchAsync(SearchRequest request) {
        CompletableFuture<SearchResponse> future = new CompletableFuture<SearchResponse>();
        this.search(request, (ActionListener<SearchResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<SearchResponse> searchScrollAsync(SearchScrollRequest request) {
        CompletableFuture<SearchResponse> future = new CompletableFuture<SearchResponse>();
        this.searchScroll(request, (ActionListener<SearchResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<MultiSearchResponse> multiSearchAsync(MultiSearchRequest request) {
        CompletableFuture<MultiSearchResponse> future = new CompletableFuture<MultiSearchResponse>();
        this.multiSearch(request, (ActionListener<MultiSearchResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<TermVectorsResponse> termVectorsAsync(TermVectorsRequest request) {
        CompletableFuture<TermVectorsResponse> future = new CompletableFuture<TermVectorsResponse>();
        this.termVectors(request, (ActionListener<TermVectorsResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<MultiTermVectorsResponse> multiTermVectorsAsync(MultiTermVectorsRequest request) {
        CompletableFuture<MultiTermVectorsResponse> future = new CompletableFuture<MultiTermVectorsResponse>();
        this.multiTermVectors(request, (ActionListener<MultiTermVectorsResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<ExplainResponse> explainAsync(ExplainRequest request) {
        CompletableFuture<ExplainResponse> future = new CompletableFuture<ExplainResponse>();
        this.explain(request, (ActionListener<ExplainResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<ClearScrollResponse> clearScrollAsync(ClearScrollRequest request) {
        CompletableFuture<ClearScrollResponse> future = new CompletableFuture<ClearScrollResponse>();
        this.clearScroll(request, (ActionListener<ClearScrollResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<FieldCapabilitiesResponse> fieldCapsAsync(FieldCapabilitiesRequest request) {
        CompletableFuture<FieldCapabilitiesResponse> future = new CompletableFuture<FieldCapabilitiesResponse>();
        this.fieldCaps(request, (ActionListener<FieldCapabilitiesResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<SearchResponse> searchViewAsync(SearchViewAction.Request request) {
        CompletableFuture<SearchResponse> future = new CompletableFuture<SearchResponse>();
        this.searchView(request, (ActionListener<SearchResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<ListViewNamesAction.Response> listViewNamesAsync(ListViewNamesAction.Request request) {
        CompletableFuture<ListViewNamesAction.Response> future = new CompletableFuture<ListViewNamesAction.Response>();
        this.listViewNames(request, (ActionListener<ListViewNamesAction.Response>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }
}

