/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.SelectorSerializer;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.w3c.dom.DOMException;

public abstract class CSSStyleDeclarationRule
extends BaseCSSDeclarationRule {
    private static final long serialVersionUID = 1L;
    private SelectorList selectorList = null;
    private String selectorText = "";

    protected CSSStyleDeclarationRule(AbstractCSSStyleSheet parentSheet, short type, byte origin) {
        super(parentSheet, type, origin);
    }

    CSSStyleDeclarationRule() {
    }

    public String getSelectorText() {
        return this.selectorText;
    }

    void setSelectorText(String selectorText) throws DOMException {
        this.selectorText = selectorText;
    }

    public void setSelectorList(SelectorList selectorList) {
        if (selectorList == null) {
            throw new NullPointerException("Null selector list");
        }
        if (selectorList.getLength() == 0) {
            throw new IllegalArgumentException("Empty selector list");
        }
        this.selectorList = selectorList;
        this.updateSelectorText();
    }

    void updateSelectorText() {
        int sz = this.selectorList.getLength();
        StringBuilder sb = new StringBuilder(sz * 7 + 5);
        if (sz > 0) {
            SelectorSerializer serializer = new SelectorSerializer(this.getParentStyleSheet());
            serializer.selectorListText(sb, this.selectorList, false, false);
        }
        this.selectorText = sb.toString();
    }

    SelectorList getSelectorList() {
        return this.selectorList;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        this.clear();
        this.selectorList = null;
        this.selectorText = "";
        CSSParser parser = (CSSParser)this.createSACParser();
        StringReader re = new StringReader(cssText);
        RuleHandler handler = new RuleHandler();
        handler.setLexicalPropertyListener(this.getLexicalPropertyListener());
        parser.setDocumentHandler(handler);
        parser.setErrorHandler(handler);
        try {
            this.parseRule((Reader)re, parser);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(50 + this.getStyle().getLength() * 24);
        try {
            this.writeCssText((SimpleWriter)sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        String seltext = this.getSelectorText();
        if (seltext.length() != 0) {
            context.startRule(wri, this.getPrecedingComments());
            wri.write((CharSequence)seltext);
            context.updateContext(this);
            context.writeLeftCurlyBracket(wri);
            context.startStyleDeclaration(wri);
            this.getStyle().writeCssText(wri, context);
            context.endCurrentContext(this);
            context.endStyleDeclaration(wri);
            context.writeRightCurlyBracket(wri);
            context.endRule(wri, this.getTrailingComments());
        }
    }

    @Override
    public String getMinifiedCssText() {
        String seltext = this.getSelectorText();
        if (seltext.length() != 0) {
            return seltext + '{' + this.getStyle().getMinifiedCssText() + '}';
        }
        return "";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.selectorList == null ? 0 : this.selectorList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CSSStyleDeclarationRule)) {
            return false;
        }
        CSSStyleDeclarationRule other = (CSSStyleDeclarationRule)obj;
        if (!super.equals(other)) {
            return false;
        }
        return !(this.selectorList == null ? other.selectorList != null : !this.selectorList.equals(other.selectorList));
    }

    @Override
    public CSSStyleDeclarationRule clone(AbstractCSSStyleSheet parentSheet) throws IllegalArgumentException {
        CSSStyleDeclarationRule rule;
        Constructor<?> ctor;
        Class[] parameterTypes = new Class[]{AbstractCSSStyleSheet.class, Byte.TYPE};
        try {
            ctor = this.getClass().getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        Object[] initargs = new Object[]{parentSheet, this.getOrigin()};
        try {
            rule = (CSSStyleDeclarationRule)ctor.newInstance(initargs);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        String oldHrefContext = this.getParentStyleSheet().getHref();
        rule.setWrappedStyle((BaseCSSStyleDeclaration)this.getStyle(), oldHrefContext);
        rule.selectorList = this.getSelectorList();
        rule.selectorText = this.getSelectorText();
        if (this.hasErrorsOrWarnings()) {
            rule.setStyleDeclarationErrorHandler(this.getStyleDeclarationErrorHandler());
        }
        return rule;
    }

    private class RuleHandler
    extends BaseCSSDeclarationRule.DeclarationRuleCSSHandler {
        private RuleHandler() {
        }

        @Override
        public void startSelector(SelectorList selectors) throws DOMException {
            if (CSSStyleDeclarationRule.this.selectorList != null) {
                throw new DOMException(3, "Rule already set, stream contains more than one rule");
            }
            CSSStyleDeclarationRule.this.setSelectorList(selectors);
        }

        @Override
        public void property(String name, LexicalUnit value, boolean important) {
            try {
                super.property(name, value, important);
            }
            catch (DOMException e) {
                CSSPropertyValueException ex = new CSSPropertyValueException(e);
                ex.setValueText(value.toString());
                CSSStyleDeclarationRule.this.getStyleDeclarationErrorHandler().wrongValue(name, ex);
            }
        }

        @Override
        public void warning(CSSParseException exception) throws CSSParseException {
            if (CSSStyleDeclarationRule.this.selectorList != null) {
                super.warning(exception);
            } else {
                AbstractCSSStyleSheet sheet = CSSStyleDeclarationRule.this.getParentStyleSheet();
                if (sheet != null) {
                    sheet.getErrorHandler().ruleParseWarning(CSSStyleDeclarationRule.this, exception);
                }
            }
        }

        @Override
        public void error(CSSParseException exception) throws CSSParseException {
            if (CSSStyleDeclarationRule.this.selectorList != null) {
                super.error(exception);
            } else {
                AbstractCSSStyleSheet sheet = CSSStyleDeclarationRule.this.getParentStyleSheet();
                if (sheet != null) {
                    sheet.getErrorHandler().ruleParseError(CSSStyleDeclarationRule.this, exception);
                }
            }
        }
    }
}

