/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSKeyframeRule;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.CSSHandler;
import io.sf.carte.doc.style.css.nsac.CSSNamespaceParseException;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.KeyframesRule;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.w3c.dom.DOMException;

public class KeyframeRule
extends BaseCSSDeclarationRule
implements CSSKeyframeRule {
    private static final long serialVersionUID = 1L;
    private final KeyframesRule parentRule;
    private String keyText;

    public KeyframeRule(KeyframesRule parentRule) {
        super(parentRule.getParentStyleSheet(), (short)8, parentRule.getOrigin());
        this.parentRule = parentRule;
    }

    @Override
    public String getKeyText() {
        return this.keyText;
    }

    void setKeyText(String keyText) {
        this.keyText = keyText;
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(50 + this.getStyle().getLength() * 24);
        try {
            this.writeCssText((SimpleWriter)sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText() {
        return this.getKeyText() + '{' + this.getStyle().getMinifiedCssText() + '}';
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        context.startRule(wri, this.getPrecedingComments());
        wri.write((CharSequence)this.getKeyText());
        context.updateContext(this);
        context.writeLeftCurlyBracket(wri);
        context.startStyleDeclaration(wri);
        this.getStyle().writeCssText(wri, context);
        context.endCurrentContext(this);
        context.endStyleDeclaration(wri);
        context.writeRightCurlyBracket(wri);
        context.endRule(wri, this.getTrailingComments());
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        MyKFHandler handler = new MyKFHandler();
        handler.setLexicalPropertyListener(this.getLexicalPropertyListener());
        StringReader re = new StringReader(cssText);
        try {
            this.parseRule((Reader)re, handler);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
    }

    @Override
    void parseRule(Reader reader, CSSHandler handler) throws IOException {
        CSSParser parser = (CSSParser)this.createSACParser();
        BaseCSSRule.AllowWarningsRuleErrorHandler errorHandler = new BaseCSSRule.AllowWarningsRuleErrorHandler();
        parser.setDocumentHandler(handler);
        parser.setErrorHandler(errorHandler);
        this.parseRule(reader, parser);
    }

    @Override
    void parseRule(Reader reader, Parser parser) throws DOMException, IOException {
        try {
            ((CSSParser)parser).parseDeclarationRule(reader);
        }
        catch (CSSNamespaceParseException e) {
            DOMException ex = new DOMException(14, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (CSSBudgetException e) {
            DOMException ex = new DOMException(9, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (CSSParseException e) {
            DOMException ex = new DOMException(12, "Parse error at [" + e.getLineNumber() + ',' + e.getColumnNumber() + "]: " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (CSSException e) {
            DOMException ex = new DOMException(15, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (RuntimeException e) {
            String href;
            String message = e.getMessage();
            AbstractCSSStyleSheet parentSS = this.getParentStyleSheet();
            if (parentSS != null && (href = parentSS.getHref()) != null) {
                message = "Error in stylesheet at " + href + ": " + message;
            }
            DOMException ex = new DOMException(11, message);
            ex.initCause(e);
            throw ex;
        }
    }

    @Override
    public KeyframesRule getParentRule() {
        return this.parentRule;
    }

    @Override
    public AbstractCSSStyleSheet getParentStyleSheet() {
        return this.parentRule.getParentStyleSheet();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.keyText == null ? 0 : this.keyText.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyframeRule other = (KeyframeRule)obj;
        return !(this.keyText == null ? other.keyText != null : !this.keyText.equals(other.keyText));
    }

    @Override
    public KeyframeRule clone(AbstractCSSStyleSheet parentSheet) {
        KeyframeRule rule = new KeyframeRule(this.getParentRule());
        rule.setKeyText(this.getKeyText());
        String oldHrefContext = this.getParentStyleSheet().getHref();
        rule.setWrappedStyle((BaseCSSStyleDeclaration)this.getStyle(), oldHrefContext);
        return rule;
    }

    private class MyKFHandler
    extends BaseCSSDeclarationRule.DeclarationRuleCSSHandler {
        private MyKFHandler() {
        }

        @Override
        public void startAtRule(String name, String pseudoSelector) {
            String selector = KeyframeRule.this.getParentRule().keyframeSelector(pseudoSelector);
            KeyframeRule.this.setKeyText(selector);
        }

        @Override
        public void property(String name, LexicalUnit value, boolean important) {
            if (important) {
                CSSPropertyValueException ex = new CSSPropertyValueException("Important declarations in a keyframe rule are not valid");
                ex.setValueText(value.toString() + " !important");
                KeyframeRule.this.getStyleDeclarationErrorHandler().wrongValue(name, ex);
            } else {
                super.property(name, value, important);
            }
        }
    }
}

