/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import java.util.List;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.authenticators.browser.SpnegoAuthenticator;
import org.keycloak.common.Profile;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;

public class SpnegoAuthenticatorFactory
implements AuthenticatorFactory {
    public static final String PROVIDER_ID = "auth-spnego";
    public static final SpnegoAuthenticator SINGLETON = new SpnegoAuthenticator();
    public static final SpnegoAuthenticator SINGLETON_DISABLED = new SpnegoAuthenticator(){

        @Override
        public void authenticate(AuthenticationFlowContext context) {
            throw new IllegalStateException("Not possible to authenticate as Kerberos feature is disabled");
        }
    };

    public Authenticator create(KeycloakSession session) {
        return this.isKerberosFeatureEnabled() ? SINGLETON : SINGLETON_DISABLED;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getReferenceCategory() {
        return "kerberos";
    }

    public boolean isConfigurable() {
        return false;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        AuthenticationExecutionModel.Requirement[] requirementArray;
        if (this.isKerberosFeatureEnabled()) {
            requirementArray = REQUIREMENT_CHOICES;
        } else {
            AuthenticationExecutionModel.Requirement[] requirementArray2 = new AuthenticationExecutionModel.Requirement[1];
            requirementArray = requirementArray2;
            requirementArray2[0] = AuthenticationExecutionModel.Requirement.DISABLED;
        }
        return requirementArray;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "Kerberos";
    }

    public String getHelpText() {
        return this.isKerberosFeatureEnabled() ? "Initiates the SPNEGO protocol.  Most often used with Kerberos." : "DISABLED. Please enable Kerberos feature and make sure Kerberos available in your platform. Initiates the SPNEGO protocol. Most often used with Kerberos.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return null;
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    private boolean isKerberosFeatureEnabled() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.KERBEROS);
    }
}

