/*
 * Decompiled with CFR 0.152.
 */
package de.tuberlin.polymake.common.io;

import de.tuberlin.polymake.common.SelectorThread;
import de.tuberlin.polymake.common.SharedMemoryMatrixException;
import de.tuberlin.polymake.common.geometry.PointSet;
import de.tuberlin.polymake.common.geometry.PolymakePoint;
import de.tuberlin.polymake.common.io.PolymakeParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class SimpleGeometryParser
extends PolymakeParser {
    public SimpleGeometryParser(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void parse(BufferedReader bufferedReader, PointSet pointSet) throws IOException, SharedMemoryMatrixException {
        Object object;
        Object object2;
        String string;
        this.error = null;
        this.warning = null;
        Vector<PolymakePoint[]> vector = new Vector<PolymakePoint[]>();
        boolean bl = false;
        this.clearParams();
        block11: while (!bl && (string = bufferedReader.readLine()) != null) {
            if (System.getProperty("polymake.debug") != null && System.getProperty("polymake.debug").equalsIgnoreCase("max")) {
                SelectorThread.newErr.println(string);
            }
            string.trim();
            switch (string.charAt(0)) {
                case 'n': {
                    this.name = string.substring(2);
                    pointSet.setName(this.name);
                    continue block11;
                }
                case 'e': {
                    this.error = string.substring(2);
                    continue block11;
                }
                case 'w': {
                    this.warning = string.substring(2);
                    continue block11;
                }
                case 'p': {
                    object2 = SimpleGeometryParser.parsePoint(string.substring(2));
                    vector.add((PolymakePoint[])object2);
                    continue block11;
                }
                case 'P': {
                    int n = Integer.parseInt(string.substring(2));
                    if (pointSet.getSMM() == null) {
                        pointSet.initSMM(n);
                    }
                    pointSet.readFromSMM();
                    continue block11;
                }
                case 'f': {
                    this.parameters.setProperty("facet", string.substring(2));
                    continue block11;
                }
                case 's': {
                    object2 = new StringTokenizer(string.substring(2));
                    object = ((StringTokenizer)object2).nextToken();
                    if (!this.parameters.keySet().contains(object)) continue block11;
                    this.parameters.setProperty((String)object, ((StringTokenizer)object2).nextToken());
                    continue block11;
                }
                case 'i': {
                    object2 = new StringTokenizer(string.substring(2));
                    object = ((StringTokenizer)object2).nextToken();
                    if (!this.parameters.keySet().contains(object)) continue block11;
                    this.iparameters.setProperty((String)object, ((StringTokenizer)object2).nextToken());
                    continue block11;
                }
                case 'x': {
                    bl = true;
                    continue block11;
                }
            }
        }
        if (vector.size() != 0) {
            object2 = new PolymakePoint[vector.size()];
            object = vector.iterator();
            for (int i = 0; i < ((PolymakePoint[])object2).length; ++i) {
                PolymakePoint polymakePoint;
                object2[i] = polymakePoint = (PolymakePoint)object.next();
            }
            pointSet.setPoints((PolymakePoint[])object2);
        }
    }

    private void clearParams() {
        for (String string : this.parameters.keySet()) {
            this.parameters.setProperty(string, "null");
        }
    }

    public Vector getFacet() {
        return SimpleGeometryParser.parseFacet(this.parameters.getProperty("facet"));
    }

    public static PolymakePoint parsePoint(String string) throws NumberFormatException {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Vector<Double> vector = new Vector<Double>();
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (((String)object).equals("l")) {
                string2 = stringTokenizer.nextToken();
                continue;
            }
            vector.add(new Double((String)object));
        }
        object = new double[vector.size()];
        int n = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            object[n++] = d;
        }
        return new PolymakePoint((double[])object, string2);
    }

    public static Vector parseFacet(String string) throws NumberFormatException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Vector<Integer> vector = new Vector<Integer>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(new Integer(stringTokenizer.nextToken()));
        }
        return vector;
    }

    /*
     * WARNING - void declaration
     */
    public static String write(PointSet pointSet, Properties properties) {
        Object object;
        Object object2 = new String();
        if (pointSet != null) {
            object2 = (String)object2 + "n " + pointSet.getName() + "\n";
            try {
                if (pointSet.getSMM() != null) {
                    pointSet.getSMM().setCoords(pointSet);
                    object2 = (String)object2 + "P " + pointSet.getSMM().getAddr() + "\n";
                } else {
                    void string;
                    PolymakePoint[] polymakePointArray = pointSet.getPoints();
                    boolean i = false;
                    while (string < polymakePointArray.length) {
                        object = polymakePointArray[string].getCoords();
                        object2 = (String)object2 + "p";
                        for (int j = 0; j < ((Object)object).length; ++j) {
                            object2 = (String)object2 + " " + (double)object[j];
                        }
                        if (polymakePointArray[string].getLabel() != null) {
                            object2 = (String)object2 + " l " + polymakePointArray[string].getLabel();
                        }
                        object2 = (String)object2 + "\n";
                        ++string;
                    }
                }
            }
            catch (SharedMemoryMatrixException sharedMemoryMatrixException) {
                sharedMemoryMatrixException.printStackTrace(SelectorThread.newErr);
            }
        }
        if (properties != null) {
            for (String string : properties.keySet()) {
                object = properties.getProperty(string);
                if (object == null) continue;
                object2 = (String)object2 + "s " + string + " " + (String)object + "\n";
            }
        }
        object2 = (String)object2 + "x\n";
        return object2;
    }

    public static String write(String string, Properties properties) {
        Object object = new String();
        object = (String)object + "n " + string + "\n";
        if (properties != null) {
            for (String string2 : properties.keySet()) {
                String string3 = properties.getProperty(string2);
                if (string3 == null) continue;
                object = (String)object + "s " + string2 + " " + string3 + "\n";
            }
        }
        object = (String)object + "x\n";
        return object;
    }

    public static String write(String string, int n) {
        Object object = new String();
        object = (String)object + "n " + string + "\n";
        object = (String)object + "p " + n + "\n";
        object = (String)object + "x\n";
        return object;
    }

    public static String write(String string, String string2, double d) {
        Object object = new String();
        object = (String)object + "n " + string + "\n";
        object = (String)object + "s " + string2 + " " + d + "\n";
        object = (String)object + "x\n";
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static String write(PointSet pointSet, Vector vector, Properties properties) {
        Object object = new String();
        try {
            Object object2;
            if (pointSet != null) {
                Object object3;
                object = (String)object + "n " + pointSet.getName() + "\n";
                if (pointSet.getSMM() != null) {
                    pointSet.writeToSMM();
                    object = (String)object + "P " + pointSet.getSMM().getAddr() + "\n";
                } else {
                    void string;
                    object3 = pointSet.getPoints();
                    boolean i = false;
                    while (string < ((PolymakePoint[])object3).length) {
                        object2 = object3[string].getCoords();
                        object = (String)object + "p";
                        for (int j = 0; j < ((Object)object2).length; ++j) {
                            object = (String)object + " " + (double)object2[j];
                        }
                        if (((PolymakePoint)object3[string]).getLabel() != null) {
                            object = (String)object + " l " + ((PolymakePoint)object3[string]).getLabel();
                        }
                        object = (String)object + "\n";
                        ++string;
                    }
                }
                object = (String)object + "f ";
                object3 = vector.iterator();
                while (object3.hasNext()) {
                    object = (String)object + (String)object3.next() + " ";
                }
                object = (String)object + "\n";
            }
            if (properties != null) {
                for (String string : properties.keySet()) {
                    object2 = properties.getProperty(string);
                    if (object2 == null) continue;
                    object = (String)object + "s " + string + " " + (String)object2 + "\n";
                }
            }
        }
        catch (SharedMemoryMatrixException sharedMemoryMatrixException) {
            sharedMemoryMatrixException.printStackTrace(SelectorThread.newErr);
        }
        object = (String)object + "x\n";
        return object;
    }

    public static String writeFacet(String string, Vector vector) {
        Object object = new String();
        object = (String)object + "n " + string + "\n";
        object = (String)object + "f ";
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            object = (String)object + (String)iterator.next() + " ";
        }
        object = (String)object + "\nx\n";
        return object;
    }

    public static String writeTransformationMatrix(double[] dArray) {
        Object object = "T";
        for (int i = 0; i < 16; ++i) {
            object = (String)object + " " + dArray[i];
        }
        return object;
    }
}

