#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-CJoEmrqeYGOKHBwEmzC07n
key:                  postgrest-10.0.0-CJoEmrqeYGOKHBwEmzC07n
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  67ba607b10f3f3918f3575f651a42d93
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.6.6/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.6.6/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-CJoEmrqeYGOKHBwEmzC07n
depends:
    HTTP-4000.4.1-3MTyhsag9CkG76BmGHJRVm
    Ranged-sets-0.5.0-8raeguCaOKrGLdE85jhucw
    aeson-2.2.0.0-4qLATSA6nfj1RfgXH6DMKK
    auto-update-0.1.6-H1huyf6QOMaDIQCgWNz2Ur base-4.18.2.1
    base64-bytestring-1.2.1.0-6srVB7ZKmzD1HZV2AV5j9d
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-HFTLAepm1u61gRs0sAANH
    cassava-0.5.4.1-8MQ5CEGKRocDMA1PJAJ47W
    configurator-pg-0.2.11-954sjp8i7D92xnQOU9d7G3 containers-0.6.7
    contravariant-extras-0.3.5.4-3woyg6AJRP6Lk666ZeP5zR
    cookie-0.5.0-Dqi2dsQ09KG8Z0mbWITxu5 directory-1.3.8.5
    either-5.0.3-L22t4kXU5q48Oo9K8geQIY
    gitrev-1.3.1-HjgHeGOzFY1JvYhlt8eDSs
    hasql-1.5.0.5-DRrkJXp2EWEjDPUUlKPIT
    hasql-dynamic-statements-0.3.1.1-1bVaZ1RyBN8EadXu3tQCH8
    hasql-notifications-0.2.0.5-50GkjSuM6DY6pbIUVJjE4Q
    hasql-pool-0.5.2.2-EsNN803VJVQDOQFCobmoLt
    hasql-transaction-1.0.1.1-DVfBIAdSF7zAbj9nfd3Vl6
    heredoc-0.2.0.0-6fzsisYvDUd6tBbd4jIzIt
    http-types-0.12.4-Hj8jLUhN6rtnIgKEy5ynr
    insert-ordered-containers-0.2.5.3-2uBs8nh67CvBIoZ6wS0yP4
    interpolatedstring-perl6-1.0.2-HPl5cn5rjz13f4TSoHQWU9
    jose-0.10-HGujWdPX7AgAuf3qQMVHhM lens-5.3.3-Ag3JywAjDxJ2k98xBhf4hs
    lens-aeson-1.2.3-LKwWspc3CGLABpwUtuPc2T mtl-2.3.1
    network-3.1.4.0-LsWsY6caX6uCNLTGwySDR3
    network-uri-2.6.4.2-3U0FvLc2coZ6tqjF5PGDly
    optparse-applicative-0.18.1.0-9I3qDpNxi1rBTnWffPMXX3
    parsec-3.1.16.1 protolude-0.3.5-9KnHbmIPQD1LWB4eqCRGHg
    regex-tdfa-1.3.2.5-4Nt33WWCOhH70pmXr5RVz
    retry-0.9.3.1-177rcdLxrcvKXTH0bhulJf
    scientific-0.3.8.0-CFYO4vxJ7Tde72prrjPHU
    swagger2-2.8.10-Gb794JXLlytHt1rZ0G9RBP text-2.0.2 time-1.12.2
    unix-2.8.4.0 unordered-containers-0.2.20.1-I6eyTXb69D2BhxejMtPouo
    vault-0.3.1.5-8aun4nqC3v9dehOIlNHGI
    vector-0.13.2.0-KFVS0U8K6eML5O0P7tVbRi
    wai-3.2.4-jofbQLzhHjJAjHqqQ1gcC
    wai-cors-0.2.7-8wfYGEE0I6u1rufSHnHt2z
    wai-extra-3.1.18-1DuUCp3G6ik2vwmaLqFrh
    wai-logger-2.5.0-LKzIqqWG7Jq5UaED2zKpoZ
    warp-3.4.0-3Ya7eYvnJ6uGkh1jTMqqfV

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

