/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.xa.OracleXAResource;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.XA})
public abstract class OracleXAConnection
extends OraclePooledConnection
implements oracle.jdbc.datasource.OracleXAConnection {
    protected XAResource xaResource;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;

    public OracleXAConnection() throws XAException {
        this((Connection)null);
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleXAConnection.class, $$$methodRef$$$3, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleXAConnection.class, $$$methodRef$$$3, null);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleXAConnection.class, $$$methodRef$$$3, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleXAConnection.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleXAConnection(Connection pc) throws XAException {
        super(pc);
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleXAConnection.class, $$$methodRef$$$4, null, pc);
            }
            this.xaResource = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleXAConnection.class, $$$methodRef$$$4, null);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleXAConnection.class, $$$methodRef$$$4, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleXAConnection.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public abstract XAResource getXAResource() throws SQLException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Connection getConnection() throws SQLException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            Connection connection;
            block19: {
                Monitor.CloseableLock lock;
                block20: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleXAConnection.class, $$$methodRef$$$0, this, new Object[0]);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        Connection conn = super.getConnection();
                        if (this.xaResource != null) {
                            ((OracleXAResource)this.xaResource).setLogicalConnection(conn);
                        }
                        connection = conn;
                        if (lock == null) break block19;
                        if (throwable == null) break block20;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleXAConnection.class, $$$methodRef$$$0, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleXAConnection.class, $$$methodRef$$$0, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block19;
                }
                lock.close();
            }
            Connection connection2 = connection;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleXAConnection.class, $$$methodRef$$$0, this, connection2);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleXAConnection.class, $$$methodRef$$$0, this, null);
            }
            return connection2;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleXAConnection.class, $$$methodRef$$$0, this, throwable8);
            }
            throw throwable;
        }
    }

    boolean getAutoCommit() throws SQLException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleXAConnection.class, $$$methodRef$$$1, this, new Object[0]);
            }
            boolean bl2 = this.autoCommit;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleXAConnection.class, $$$methodRef$$$1, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleXAConnection.class, $$$methodRef$$$1, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleXAConnection.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setAutoCommit(boolean bl) throws SQLException {
        boolean bl2 = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleXAConnection.class, $$$methodRef$$$2, this, bl);
            }
            this.autoCommit = value;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleXAConnection.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleXAConnection.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleXAConnection.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$4 = OracleXAConnection.class.getDeclaredConstructor(Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleXAConnection.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleXAConnection.class.getDeclaredMethod("setAutoCommit", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleXAConnection.class.getDeclaredMethod("getAutoCommit", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleXAConnection.class.getDeclaredMethod("getConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

