/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.server.mysql;

import java.util.regex.Pattern;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionExclusionRule;
import schemacrawler.plugin.EnumDataTypeHelper;
import schemacrawler.server.mysql.MySQLEnumDataTypeHelper;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.databaseconnector.DatabaseConnectorOptions;
import schemacrawler.tools.databaseconnector.DatabaseConnectorOptionsBuilder;
import schemacrawler.tools.executable.commandline.PluginCommand;
import us.fatehi.utility.datasource.DatabaseConnectionSourceBuilder;
import us.fatehi.utility.datasource.DatabaseServerType;

public final class MySQLDatabaseConnector
extends DatabaseConnector {
    private static DatabaseConnectorOptions databaseConnectorOptions() {
        DatabaseServerType dbServerType = new DatabaseServerType("mysql", "MySQL");
        DatabaseConnectionSourceBuilder connectionSourceBuilder = DatabaseConnectionSourceBuilder.builder((String)"jdbc:mysql://${host}:${port}/${database}").withDefaultPort(3306).withDefaultUrlx("allowPublicKeyRetrieval", true).withDefaultUrlx("nullNamePatternMatchesAll", true).withDefaultUrlx("getProceduresReturnsFunctions", false).withDefaultUrlx("noAccessToProcedureBodies", true).withDefaultUrlx("logger", "Jdk14Logger").withDefaultUrlx("dumpQueriesOnException", true).withDefaultUrlx("dumpMetadataOnColumnNotFound", true).withDefaultUrlx("maxQuerySizeToLog", "4096").withDefaultUrlx("disableMariaDbDriver", true).withDefaultUrlx("useInformationSchema", true);
        PluginCommand pluginCommand = PluginCommand.newDatabasePluginCommand((DatabaseServerType)dbServerType);
        pluginCommand.addOption("server", String.class, new String[]{"--server=mysql%nLoads SchemaCrawler plug-in for MySQL"}).addOption("host", String.class, new String[]{"Host name%nOptional, defaults to localhost"}).addOption("port", Integer.class, new String[]{"Port number%nOptional, defaults to 3306"}).addOption("database", String.class, new String[]{"Database name"});
        return (DatabaseConnectorOptions)DatabaseConnectorOptionsBuilder.builder((DatabaseServerType)dbServerType).withHelpCommand(pluginCommand).withUrlSupportPredicate(url -> url != null && Pattern.matches("jdbc:(mysql|mariadb):.*", url)).withInformationSchemaViewsFromResourceFolder("/mysql.information_schema").withSchemaRetrievalOptionsBuilder((schemaRetrievalOptionsBuilder, connection) -> schemaRetrievalOptionsBuilder.withEnumDataTypeHelper((EnumDataTypeHelper)new MySQLEnumDataTypeHelper())).withLimitOptionsBuilder(limitOptionsBuilder -> limitOptionsBuilder.includeSchemas((InclusionRule)new RegularExpressionExclusionRule("sys|mysql"))).withDatabaseConnectionSourceBuilder(() -> connectionSourceBuilder).build();
    }

    public MySQLDatabaseConnector() {
        super(MySQLDatabaseConnector.databaseConnectorOptions());
    }
}

