/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.OptionPanel;
import org.freeplane.core.resources.components.OptionPanelWindowConfigurationStorage;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;

public final class PreferencesDialogLauncher {
    private PreferencesDialogLauncher() {
    }

    public static void open(DefaultMutableTreeNode controls, boolean arePropertyValidatorsEnabled, ActionEvent triggeringEvent) {
        PreferencesDialogLauncher.open(controls, null, arePropertyValidatorsEnabled, triggeringEvent);
    }

    public static void open(DefaultMutableTreeNode controls, final String selectedProperty, boolean arePropertyValidatorsEnabled, ActionEvent triggeringEvent) {
        String actionCommand;
        Object source;
        JDialog dialog = null;
        if (triggeringEvent != null && (source = triggeringEvent.getSource()) instanceof Component) {
            Window window = SwingUtilities.getWindowAncestor((Component)source);
            dialog = PreferencesDialogLauncher.createDialog(window);
        }
        if (dialog == null) {
            dialog = PreferencesDialogLauncher.createDialog((Window)UITools.getMenuComponent());
        }
        if (dialog == null) {
            return;
        }
        dialog.setResizable(true);
        dialog.setUndecorated(false);
        final OptionPanel options = new OptionPanel(dialog, new OptionPanel.IOptionPanelFeedback(){

            @Override
            public void writeProperties(Properties props) {
                boolean propertiesChanged = false;
                for (Object keyObject : props.keySet()) {
                    String key = keyObject.toString();
                    String newProperty = props.getProperty(key);
                    propertiesChanged = propertiesChanged || !newProperty.equals(ResourceController.getResourceController().getProperty(key));
                    ResourceController.getResourceController().setProperty(key, newProperty);
                }
                if (propertiesChanged) {
                    JOptionPane.showMessageDialog(UITools.getMenuComponent(), TextUtils.getText("option_changes_may_require_restart"));
                    ResourceController.getResourceController().saveProperties();
                    UITools.resetMenuBarOnMac();
                }
            }
        });
        if (arePropertyValidatorsEnabled) {
            options.enablePropertyValidators();
        }
        String marshalled = ResourceController.getResourceController().getProperty("OptionPanel_Window_Properties");
        OptionPanelWindowConfigurationStorage storage = OptionPanelWindowConfigurationStorage.decorateDialog(marshalled, dialog);
        String string = actionCommand = triggeringEvent != null ? triggeringEvent.getActionCommand() : null;
        if (actionCommand != null && actionCommand.startsWith("OptionPanel.")) {
            options.setSelectedPanel(actionCommand);
        } else if (storage != null) {
            options.setSelectedPanel(storage.getPanel());
        }
        options.buildPanel(controls);
        options.setProperties();
        String title = TextUtils.getText("ShowPreferencesAction.dialog");
        dialog.setTitle(title);
        dialog.setDefaultCloseOperation(2);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                options.closeWindow();
            }
        });
        AbstractAction action = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                options.closeWindow();
            }
        };
        UITools.addEscapeActionToDialog(dialog, action);
        if (storage == null) {
            UITools.setBounds(dialog, -1, -1, dialog.getPreferredSize().width + 50, -1);
        }
        if (selectedProperty != null) {
            ComponentAdapter visibilityListener = new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent evt) {
                    options.highlight(selectedProperty);
                }
            };
            dialog.addComponentListener(visibilityListener);
        }
        dialog.setVisible(true);
    }

    private static JDialog createDialog(Window window) {
        if (window instanceof Dialog) {
            JDialog dialog = new JDialog((Dialog)window, true);
            dialog.applyComponentOrientation(window.getComponentOrientation());
            return dialog;
        }
        if (window instanceof Frame) {
            JDialog dialog = new JDialog((Frame)window, true);
            dialog.applyComponentOrientation(window.getComponentOrientation());
            return dialog;
        }
        return null;
    }
}

