/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine;

import io.sf.carte.doc.style.css.BooleanCondition;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.om.CSSOMParser;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.Rule;
import io.sf.carte.echosvg.css.engine.StyleSheet;
import org.w3c.dom.DOMException;

public class SupportsRule
extends StyleSheet
implements Rule {
    public static final short TYPE = 12;
    private BooleanCondition condition;
    boolean supports;

    public SupportsRule(BooleanCondition condition) {
        this.condition = condition;
    }

    @Override
    public short getType() {
        return 12;
    }

    public BooleanCondition getCondition() {
        return this.condition;
    }

    public String getConditionText() {
        return this.condition != null ? this.condition.toString() : "";
    }

    public void setConditionText(String conditionText) throws DOMException {
        this.parseConditionText(conditionText);
    }

    private void parseConditionText(String conditionText) throws DOMException {
        CSSOMParser parser = new CSSOMParser();
        try {
            this.condition = parser.parseSupportsCondition(conditionText, null);
        }
        catch (CSSBudgetException e) {
            DOMException ex = new DOMException(9, "Limit found while parsing condition " + conditionText);
            ex.initCause(e);
            throw ex;
        }
        catch (CSSException e) {
            DOMException ex = new DOMException(12, "Error parsing condition: " + conditionText);
            ex.initCause(e);
            throw ex;
        }
    }

    @Override
    public String toString(CSSEngine eng) {
        StringBuilder sb = new StringBuilder();
        sb.append("@supports");
        if (this.condition != null) {
            sb.append(this.condition.toString());
        }
        sb.append(" {\n");
        for (int i = 0; i < this.size; ++i) {
            sb.append(this.rules[i].toString(eng));
        }
        sb.append("}\n");
        return sb.toString();
    }
}

