/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.echosvg.css.engine.value.ColorValue;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.NumericValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.svg.SVGValueConstants;
import org.w3c.api.DOMSyntaxException;
import org.w3c.css.om.typed.CSSLab;
import org.w3c.css.om.typed.CSSNumericValue;
import org.w3c.dom.DOMException;

public class LabColorValue
extends ColorValue
implements CSSLab {
    private static final long serialVersionUID = 1L;
    protected NumericValue l;
    protected NumericValue a;
    protected NumericValue b;

    public LabColorValue(NumericValue l, NumericValue a, NumericValue b) throws DOMSyntaxException {
        this(l, a, b, SVGValueConstants.NUMBER_1);
    }

    public LabColorValue(NumericValue l, NumericValue a, NumericValue b, NumericValue alpha) throws DOMSyntaxException {
        super(alpha);
        this.setL(l);
        this.setA(a);
        this.setB(b);
    }

    @Override
    public String getCSSColorSpace() {
        return "lab";
    }

    public String getCssText() {
        StringBuilder buf = new StringBuilder();
        buf.append("lab(").append(this.l.getCssText()).append(' ').append(this.a.getCssText()).append(' ').append(this.b.getCssText());
        if (!this.isOpaque()) {
            buf.append(' ').append(this.getAlpha().getCssText());
        }
        buf.append(')');
        return buf.toString();
    }

    public NumericValue getL() {
        return this.l;
    }

    public NumericValue getA() {
        return this.a;
    }

    public NumericValue getB() {
        return this.b;
    }

    public void setL(double lightness) {
        this.l = new FloatValue(2, (float)lightness);
        this.componentize(this.l);
        this.componentChanged(this.l);
    }

    public void setL(CSSNumericValue lightness) throws DOMSyntaxException {
        this.l = this.component(lightness);
        this.componentChanged(this.l);
    }

    private NumericValue component(CSSNumericValue c) throws DOMSyntaxException {
        NumericValue ch = (NumericValue)c;
        if (ch.getUnitType() != 2 && ch.getUnitType() != 0) {
            throw new DOMSyntaxException("Lab component must be a number or percentage.");
        }
        if (ch.handler != null) {
            ch = ch.clone();
        }
        this.componentize(ch);
        return ch;
    }

    public void setA(double a) {
        this.a = new FloatValue(0, (float)a);
        this.componentize(this.a);
        this.componentChanged(this.a);
    }

    public void setA(CSSNumericValue a) throws DOMSyntaxException {
        this.a = this.component(a);
        this.componentChanged(this.a);
    }

    public void setB(double b) {
        this.b = new FloatValue(0, (float)b);
        this.componentize(this.b);
        this.componentChanged(this.b);
    }

    public void setB(CSSNumericValue b) throws DOMSyntaxException {
        this.b = this.component(b);
        this.componentChanged(this.b);
    }

    @Override
    public int getLength() throws DOMException {
        return 4;
    }

    @Override
    public Value item(int index) throws DOMException {
        switch (index) {
            case 0: {
                return this.getL();
            }
            case 1: {
                return this.getA();
            }
            case 2: {
                return this.getB();
            }
            case 3: {
                return this.getAlpha();
            }
        }
        return null;
    }

    @Override
    public LabColorValue clone() {
        LabColorValue clon = (LabColorValue)super.clone();
        clon.l = this.l.clone();
        clon.a = this.a.clone();
        clon.b = this.b.clone();
        return clon;
    }
}

