/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.io.IOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AttributeContainerSerializer;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

public class DeduplicatingAttributeContainerSerializer
implements AttributeContainerSerializer {
    private final IdentityHashMap<AttributeContainer, Integer> writeIndex = new IdentityHashMap();
    private final List<ImmutableAttributes> readIndex = new ArrayList<ImmutableAttributes>();
    private final AttributeContainerSerializer delegate;

    public DeduplicatingAttributeContainerSerializer(AttributeContainerSerializer delegate) {
        this.delegate = delegate;
    }

    @Override
    public ImmutableAttributes read(Decoder decoder) throws IOException {
        ImmutableAttributes attributes;
        boolean empty = decoder.readBoolean();
        if (empty) {
            return ImmutableAttributes.EMPTY;
        }
        int idx = decoder.readSmallInt();
        if (idx == this.readIndex.size()) {
            attributes = this.delegate.read(decoder);
            this.readIndex.add(attributes);
        } else {
            attributes = this.readIndex.get(idx);
        }
        return attributes;
    }

    @Override
    public void write(Encoder encoder, AttributeContainer container) throws IOException {
        if (container.isEmpty()) {
            encoder.writeBoolean(true);
            return;
        }
        encoder.writeBoolean(false);
        Integer idx = this.writeIndex.get(container);
        if (idx == null) {
            int index = this.writeIndex.size();
            encoder.writeSmallInt(index);
            this.writeIndex.put(container, index);
            this.delegate.write(encoder, container);
        } else {
            encoder.writeSmallInt(idx.intValue());
        }
    }
}

