/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.tags;

import io.opencensus.internal.StringUtils;
import io.opencensus.internal.Utils;
import io.opencensus.tags.AutoValue_TagKey;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class TagKey {
    public static final int MAX_LENGTH = 255;

    TagKey() {
    }

    public static TagKey create(String name) {
        Utils.checkArgument(TagKey.isValid(name), "Invalid TagKey name: %s", name);
        return new AutoValue_TagKey(name);
    }

    public abstract String getName();

    private static boolean isValid(String name) {
        return !name.isEmpty() && name.length() <= 255 && StringUtils.isPrintableString(name);
    }
}

