/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LobCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.NCLOB;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class ClobAccessor
extends LobCommonAccessor {
    static final int MAXLENGTH = 4000;
    int[] prefetchedDataCharset;
    int[] prefetchedDataFormOfUse;
    private CharacterSet cachedCharSet;
    private CharacterSet ucs2CompatibleCharSet;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;

    ClobAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        super(form == 2 ? Representation.NCLOB : Representation.CLOB, stmt, 4000, forBind);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, ClobAccessor.class, $$$methodRef$$$25, null, stmt, max_len, form, external_type, forBind);
            }
            this.cachedCharSet = null;
            this.ucs2CompatibleCharSet = null;
            this.init(stmt, 112, 112, form, forBind);
            this.initForDataAccess(external_type, max_len, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, ClobAccessor.class, $$$methodRef$$$25, null);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, ClobAccessor.class, $$$methodRef$$$25, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, ClobAccessor.class, $$$methodRef$$$25, null, throwable2);
            }
            throw throwable;
        }
    }

    ClobAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(form == 2 ? Representation.NCLOB : Representation.CLOB, stmt, 4000, false);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, ClobAccessor.class, $$$methodRef$$$26, null, stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form);
            }
            this.cachedCharSet = null;
            this.ucs2CompatibleCharSet = null;
            this.init(stmt, 112, 112, form, false);
            this.initForDescribe(112, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
            this.initForDataAccess(0, max_len, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, ClobAccessor.class, $$$methodRef$$$26, null);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, ClobAccessor.class, $$$methodRef$$$26, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, ClobAccessor.class, $$$methodRef$$$26, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void setCapacity(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void capacity;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, ClobAccessor.class, $$$methodRef$$$0, this, n2);
            }
            super.setCapacity((int)capacity);
            if (this.prefetchedDataCharset == null) {
                this.prefetchedDataCharset = new int[capacity];
                this.prefetchedDataFormOfUse = new int[capacity];
            } else if (capacity > this.prefetchedDataCharset.length) {
                int[] tmp = new int[capacity];
                System.arraycopy(this.prefetchedDataCharset, 0, tmp, 0, this.prefetchedDataCharset.length);
                this.prefetchedDataCharset = tmp;
                tmp = new int[capacity];
                System.arraycopy(this.prefetchedDataFormOfUse, 0, tmp, 0, this.prefetchedDataFormOfUse.length);
                this.prefetchedDataFormOfUse = tmp;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, ClobAccessor.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ClobAccessor.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ClobAccessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void insertNull(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void rowIndex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, ClobAccessor.class, $$$methodRef$$$1, this, n2);
            }
            System.arraycopy(this.prefetchedDataCharset, (int)rowIndex, this.prefetchedDataCharset, (int)(rowIndex + true), this.prefetchedDataCharset.length - rowIndex - 1);
            System.arraycopy(this.prefetchedDataFormOfUse, (int)rowIndex, this.prefetchedDataFormOfUse, (int)(rowIndex + true), this.prefetchedDataFormOfUse.length - rowIndex - 1);
            super.insertNull((int)rowIndex);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, ClobAccessor.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ClobAccessor.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ClobAccessor.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Accessor copyForDefine(OracleStatement oracleStatement) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void dest;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, ClobAccessor.class, $$$methodRef$$$2, this, oracleStatement);
            }
            ClobAccessor acc = (ClobAccessor)super.copyForDefine((OracleStatement)dest);
            acc.prefetchedDataCharset = null;
            acc.prefetchedDataFormOfUse = null;
            ClobAccessor clobAccessor = acc;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, ClobAccessor.class, $$$methodRef$$$2, this, clobAccessor);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, ClobAccessor.class, $$$methodRef$$$2, this, null);
            }
            return clobAccessor;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, ClobAccessor.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void copyFromInternal(Accessor accessor, int n2, int n3) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void destRow;
            void srcRow;
            void srcAcc;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, ClobAccessor.class, $$$methodRef$$$3, this, accessor, n2, n3);
            }
            super.copyFromInternal((Accessor)srcAcc, (int)srcRow, (int)destRow);
            if (this.isPrefetched()) {
                ClobAccessor srcClobAcc = (ClobAccessor)srcAcc;
                this.setPrefetchedDataCharset((int)destRow, srcClobAcc.getPrefetchedDataCharset((int)srcRow));
                this.setPrefetchedDataFormOfUse((int)destRow, srcClobAcc.getPrefetchedDataFormOfUse((int)srcRow));
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, ClobAccessor.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ClobAccessor.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ClobAccessor.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void deleteRow(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void row;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, ClobAccessor.class, $$$methodRef$$$4, this, n2);
            }
            super.deleteRow((int)row);
            if (this.isPrefetched()) {
                this.delete(this.prefetchedDataCharset, (int)row);
                this.delete(this.prefetchedDataFormOfUse, (int)row);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, ClobAccessor.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, ClobAccessor.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, ClobAccessor.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final int getPrefetchedDataCharset(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, ClobAccessor.class, $$$methodRef$$$5, this, n2);
            }
            int n3 = this.prefetchedDataCharset[currentRow];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ClobAccessor.class, $$$methodRef$$$5, this, n3);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ClobAccessor.class, $$$methodRef$$$5, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ClobAccessor.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void setPrefetchedDataCharset(int n2, int n3) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void charSet;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, ClobAccessor.class, $$$methodRef$$$6, this, n2, n3);
            }
            this.prefetchedDataCharset[currentRow] = charSet;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, ClobAccessor.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, ClobAccessor.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, ClobAccessor.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final int getPrefetchedDataFormOfUse(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, ClobAccessor.class, $$$methodRef$$$7, this, n2);
            }
            int n3 = this.prefetchedDataFormOfUse[currentRow];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, ClobAccessor.class, $$$methodRef$$$7, this, n3);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, ClobAccessor.class, $$$methodRef$$$7, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, ClobAccessor.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void setPrefetchedDataFormOfUse(int n2, int n3) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void formOfUse;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, ClobAccessor.class, $$$methodRef$$$8, this, n2, n3);
            }
            this.prefetchedDataFormOfUse[currentRow] = formOfUse;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, ClobAccessor.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, ClobAccessor.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, ClobAccessor.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, ClobAccessor.class, $$$methodRef$$$9, this, n2);
            }
            CLOB cLOB = this.getCLOB((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, ClobAccessor.class, $$$methodRef$$$9, this, cLOB);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, ClobAccessor.class, $$$methodRef$$$9, this, null);
            }
            return cLOB;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, ClobAccessor.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2, Map<String, Class<?>> map) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, ClobAccessor.class, $$$methodRef$$$10, this, n2, map);
            }
            CLOB cLOB = this.getCLOB((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, ClobAccessor.class, $$$methodRef$$$10, this, cLOB);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, ClobAccessor.class, $$$methodRef$$$10, this, null);
            }
            return cLOB;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, ClobAccessor.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Datum getOracleObject(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, ClobAccessor.class, $$$methodRef$$$11, this, n2);
            }
            CLOB cLOB = this.getCLOB((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, ClobAccessor.class, $$$methodRef$$$11, this, cLOB);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, ClobAccessor.class, $$$methodRef$$$11, this, null);
            }
            return cLOB;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, ClobAccessor.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void normalizeFormOfUse(byte[] byArray) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void locator;
            short formOfUseFromLocator;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, ClobAccessor.class, $$$methodRef$$$12, this, new Object[]{byArray});
            }
            if ((formOfUseFromLocator = oracle.sql.CLOB.getFormOfUseFromLocator((byte[])locator)) != -1) {
                this.formOfUse = formOfUseFromLocator;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, ClobAccessor.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, ClobAccessor.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, ClobAccessor.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private CLOB getCLOB_(int n2, byte[] byArray) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void locator;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, ClobAccessor.class, $$$methodRef$$$13, this, n2, byArray);
            }
            CLOB result = this.formOfUse == 1 ? new CLOB((OracleConnection)this.statement.connection, (byte[])locator, this.formOfUse) : new NCLOB(this.statement.connection, (byte[])locator);
            if (this.isPrefetched()) {
                void currentRow;
                result.setActivePrefetch(true);
                result.setLength(this.getPrefetchedLength((int)currentRow));
                result.setChunkSize(this.getPrefetchedChunkSize((int)currentRow));
                int[] cLength = new int[1];
                result.setPrefetchedData(this.getPrefetchedCharData((int)currentRow, cLength), cLength[0]);
            }
            if (result.isTemporary()) {
                this.statement.connection.addTemporaryLob(result);
            }
            CLOB cLOB = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, ClobAccessor.class, $$$methodRef$$$13, this, cLOB);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, ClobAccessor.class, $$$methodRef$$$13, this, null);
            }
            return cLOB;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, ClobAccessor.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    CLOB getCLOB(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            CLOB result;
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, ClobAccessor.class, $$$methodRef$$$14, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                CLOB cLOB = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, ClobAccessor.class, $$$methodRef$$$14, this, cLOB);
                    ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, ClobAccessor.class, $$$methodRef$$$14, this, null);
                }
                return null;
            }
            byte[] locator = this.getBytesInternal((int)currentRow);
            this.normalizeFormOfUse(locator);
            CLOB cLOB = result = this.getCLOB_((int)currentRow, locator);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, ClobAccessor.class, $$$methodRef$$$14, this, cLOB);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, ClobAccessor.class, $$$methodRef$$$14, this, null);
            }
            return cLOB;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, ClobAccessor.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    NCLOB getNCLOB(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, ClobAccessor.class, $$$methodRef$$$15, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                NCLOB nCLOB = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, ClobAccessor.class, $$$methodRef$$$15, this, nCLOB);
                    ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, ClobAccessor.class, $$$methodRef$$$15, this, null);
                }
                return null;
            }
            byte[] locator = this.getBytesInternal((int)currentRow);
            this.normalizeFormOfUse(locator);
            if (this.formOfUse != 2) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$15, Level.FINEST, ClobAccessor.class, $$$methodRef$$$15, this, sQLException);
                }
                throw sQLException;
            }
            NCLOB nCLOB = (NCLOB)this.getCLOB_((int)currentRow, locator);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, ClobAccessor.class, $$$methodRef$$$15, this, nCLOB);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, ClobAccessor.class, $$$methodRef$$$15, this, null);
            }
            return nCLOB;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, ClobAccessor.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final char[] XgetPrefetchedCharData(int n2, int[] nArray) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, ClobAccessor.class, $$$methodRef$$$16, this, n2, nArray);
            }
            if (this.getPrefetchLength() == -1) {
                char[] cArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, ClobAccessor.class, $$$methodRef$$$16, this, cArray);
                    ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, ClobAccessor.class, $$$methodRef$$$16, this, null);
                }
                return null;
            }
            int nbOfCharsFromConversion = -1;
            int nbOfBytesFromNetwork = this.getPrefetchedDataLength((int)currentRow);
            char[] charsData = new char[this.getPrefetchedDataLength((int)currentRow)];
            byte[] prefetchedData = this.rowData.get(this.getPrefetchedDataOffset((int)currentRow), this.getPrefetchedDataLength((int)currentRow));
            if (this.getPrefetchedDataCharset((int)currentRow) != 0) {
                nbOfCharsFromConversion = this.getPrefetchedDataCharset((int)currentRow) == 2000 ? CharacterSet.convertAL16UTF16BytesToJavaChars(prefetchedData, 0, charsData, 0, nbOfBytesFromNetwork, true) : CharacterSet.convertAL16UTF16LEBytesToJavaChars(prefetchedData, 0, charsData, 0, nbOfBytesFromNetwork, true);
            } else {
                int[] nbOfBytesArr = new int[]{nbOfBytesFromNetwork};
                nbOfCharsFromConversion = this.formOfUse == 1 ? this.statement.connection.conversion.CHARBytesToJavaChars(prefetchedData, 0, charsData, 0, nbOfBytesArr, charsData.length) : this.statement.connection.conversion.NCHARBytesToJavaChars(prefetchedData, 0, charsData, 0, nbOfBytesArr, charsData.length);
            }
            out_charLength[0] = nbOfCharsFromConversion;
            char[] cArray = charsData;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, ClobAccessor.class, $$$methodRef$$$16, this, cArray);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, ClobAccessor.class, $$$methodRef$$$16, this, null);
            }
            return charsData;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, ClobAccessor.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final char[] getPrefetchedCharData(int n2, int[] nArray) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            char[] c2;
            void out_charLength;
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, ClobAccessor.class, $$$methodRef$$$17, this, n2, nArray);
            }
            if (this.getPrefetchLength() == -1) {
                char[] cArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, ClobAccessor.class, $$$methodRef$$$17, this, cArray);
                    ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, ClobAccessor.class, $$$methodRef$$$17, this, null);
                }
                return null;
            }
            if (this.getPrefetchedDataCharset((int)currentRow) == 0) {
                char[] c3;
                char[] cArray = c3 = this.rowData.getChars(this.getPrefetchedDataOffset((int)currentRow), this.getPrefetchedDataLength((int)currentRow), this.statement.connection.conversion.getCharacterSet((short)this.getPrefetchedDataFormOfUse((int)currentRow)), (int[])out_charLength);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, ClobAccessor.class, $$$methodRef$$$17, this, cArray);
                    ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, ClobAccessor.class, $$$methodRef$$$17, this, null);
                }
                return c3;
            }
            if (this.cachedCharSet == null || this.cachedCharSet.getOracleId() != this.getPrefetchedDataCharset((int)currentRow)) {
                this.cachedCharSet = CharacterSet.make(this.getPrefetchedDataCharset((int)currentRow));
            }
            char[] cArray = c2 = this.rowData.getChars(this.getPrefetchedDataOffset((int)currentRow), this.getPrefetchedDataLength((int)currentRow), this.cachedCharSet, (int[])out_charLength);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, ClobAccessor.class, $$$methodRef$$$17, this, cArray);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, ClobAccessor.class, $$$methodRef$$$17, this, null);
            }
            return c2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, ClobAccessor.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    InputStream getAsciiStream(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            CLOB clob;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, ClobAccessor.class, $$$methodRef$$$18, this, n2);
            }
            if ((clob = this.getCLOB((int)currentRow)) == null) {
                InputStream inputStream = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, ClobAccessor.class, $$$methodRef$$$18, this, inputStream);
                    ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, ClobAccessor.class, $$$methodRef$$$18, this, null);
                }
                return null;
            }
            InputStream inputStream = clob.getAsciiStream(true);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, ClobAccessor.class, $$$methodRef$$$18, this, inputStream);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, ClobAccessor.class, $$$methodRef$$$18, this, null);
            }
            return inputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, ClobAccessor.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Reader getCharacterStream(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            CLOB clob;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, ClobAccessor.class, $$$methodRef$$$19, this, n2);
            }
            if ((clob = this.getCLOB((int)currentRow)) == null) {
                Reader reader = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, ClobAccessor.class, $$$methodRef$$$19, this, reader);
                    ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, ClobAccessor.class, $$$methodRef$$$19, this, null);
                }
                return null;
            }
            Reader reader = clob.getCharacterStream();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, ClobAccessor.class, $$$methodRef$$$19, this, reader);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, ClobAccessor.class, $$$methodRef$$$19, this, null);
            }
            return reader;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, ClobAccessor.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    InputStream getBinaryStream(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            CLOB clob;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, ClobAccessor.class, $$$methodRef$$$20, this, n2);
            }
            if ((clob = this.getCLOB((int)currentRow)) == null) {
                InputStream inputStream = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, ClobAccessor.class, $$$methodRef$$$20, this, inputStream);
                    ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, ClobAccessor.class, $$$methodRef$$$20, this, null);
                }
                return null;
            }
            InputStream inputStream = clob.getAsciiStream();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, ClobAccessor.class, $$$methodRef$$$20, this, inputStream);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, ClobAccessor.class, $$$methodRef$$$20, this, null);
            }
            return inputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, ClobAccessor.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    String getString(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, ClobAccessor.class, $$$methodRef$$$21, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                String string = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, ClobAccessor.class, $$$methodRef$$$21, this, string);
                    ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, ClobAccessor.class, $$$methodRef$$$21, this, null);
                }
                return null;
            }
            if (this.isPrefetched() && this.getPrefetchedLength((int)currentRow) > Integer.MAX_VALUE) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 151).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$21, Level.FINEST, ClobAccessor.class, $$$methodRef$$$21, this, sQLException);
                }
                throw sQLException;
            }
            CLOB clob = this.getCLOB((int)currentRow);
            if (clob == null) {
                String string = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, ClobAccessor.class, $$$methodRef$$$21, this, string);
                    ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, ClobAccessor.class, $$$methodRef$$$21, this, null);
                }
                return null;
            }
            if (clob.isTemporary()) {
                this.statement.addToTempLobsToFree(clob);
            }
            if (this.isPrefetched()) {
                if (this.statement.definedColumnSize != null && this.statement.definedColumnSize.length > currentRow && this.getPrefetchedLength((int)currentRow) <= (long)this.statement.definedColumnSize[currentRow] && this.getPrefetchedDataCharset((int)currentRow) != 0) {
                    if (this.ucs2CompatibleCharSet == null || this.ucs2CompatibleCharSet.getOracleId() != this.getPrefetchedDataCharset((int)currentRow)) {
                        this.ucs2CompatibleCharSet = this.getPrefetchedDataCharset((int)currentRow) == 2000 ? CharacterSet.make(2000) : CharacterSet.make(2002);
                    }
                    String string = this.rowData.getString(this.getPrefetchedDataOffset((int)currentRow), this.getPrefetchedDataLength((int)currentRow), this.ucs2CompatibleCharSet);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, ClobAccessor.class, $$$methodRef$$$21, this, string);
                        ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, ClobAccessor.class, $$$methodRef$$$21, this, null);
                    }
                    return string;
                }
                String string = clob.getSubString(1L, (int)this.getPrefetchedLength((int)currentRow));
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, ClobAccessor.class, $$$methodRef$$$21, this, string);
                    ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, ClobAccessor.class, $$$methodRef$$$21, this, null);
                }
                return string;
            }
            String string = this.getStringNoPrefetch((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, ClobAccessor.class, $$$methodRef$$$21, this, string);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, ClobAccessor.class, $$$methodRef$$$21, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, ClobAccessor.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    String getStringNoPrefetch(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            CLOB clob;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, ClobAccessor.class, $$$methodRef$$$22, this, n2);
            }
            if ((clob = this.getCLOB((int)currentRow)) == null) {
                String string = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, ClobAccessor.class, $$$methodRef$$$22, this, string);
                    ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, ClobAccessor.class, $$$methodRef$$$22, this, null);
                }
                return null;
            }
            Reader r2 = clob.getCharacterStream();
            int size = clob.getBufferSize();
            int length = 0;
            StringWriter w2 = new StringWriter(size);
            char[] buffer = new char[size];
            try {
                while ((length = r2.read(buffer)) != -1) {
                    w2.write(buffer, 0, length);
                }
            }
            catch (IOException ex) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, ClobAccessor.class, $$$methodRef$$$22, this, sQLException);
                }
                throw sQLException;
            }
            catch (IndexOutOfBoundsException x2) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 151).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, ClobAccessor.class, $$$methodRef$$$22, this, sQLException);
                }
                throw sQLException;
            }
            if (clob.isTemporary()) {
                this.statement.addToTempLobsToFree(clob);
            }
            String string = w2.getBuffer().substring(0);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, ClobAccessor.class, $$$methodRef$$$22, this, string);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, ClobAccessor.class, $$$methodRef$$$22, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, ClobAccessor.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    byte[] getBytes(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, ClobAccessor.class, $$$methodRef$$$23, this, n2);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getBytes").fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$23, Level.FINEST, ClobAccessor.class, $$$methodRef$$$23, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, ClobAccessor.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    long updateChecksum(long l2, int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, ClobAccessor.class, $$$methodRef$$$24, this, l2, n2);
            }
            this.unimpl("updateChecksum");
            long l3 = -1L;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, ClobAccessor.class, $$$methodRef$$$24, this, l3);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, ClobAccessor.class, $$$methodRef$$$24, this, null);
            }
            return -1L;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, ClobAccessor.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$26 = ClobAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = ClobAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Short.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = ClobAccessor.class.getDeclaredMethod("updateChecksum", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = ClobAccessor.class.getDeclaredMethod("getBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = ClobAccessor.class.getDeclaredMethod("getStringNoPrefetch", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = ClobAccessor.class.getDeclaredMethod("getString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = ClobAccessor.class.getDeclaredMethod("getBinaryStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = ClobAccessor.class.getDeclaredMethod("getCharacterStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = ClobAccessor.class.getDeclaredMethod("getAsciiStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = ClobAccessor.class.getDeclaredMethod("getPrefetchedCharData", Integer.TYPE, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = ClobAccessor.class.getDeclaredMethod("XgetPrefetchedCharData", Integer.TYPE, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = ClobAccessor.class.getDeclaredMethod("getNCLOB", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = ClobAccessor.class.getDeclaredMethod("getCLOB", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = ClobAccessor.class.getDeclaredMethod("getCLOB_", Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = ClobAccessor.class.getDeclaredMethod("normalizeFormOfUse", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = ClobAccessor.class.getDeclaredMethod("getOracleObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = ClobAccessor.class.getDeclaredMethod("getObject", Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = ClobAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = ClobAccessor.class.getDeclaredMethod("setPrefetchedDataFormOfUse", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = ClobAccessor.class.getDeclaredMethod("getPrefetchedDataFormOfUse", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = ClobAccessor.class.getDeclaredMethod("setPrefetchedDataCharset", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = ClobAccessor.class.getDeclaredMethod("getPrefetchedDataCharset", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = ClobAccessor.class.getDeclaredMethod("deleteRow", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = ClobAccessor.class.getDeclaredMethod("copyFromInternal", Accessor.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = ClobAccessor.class.getDeclaredMethod("copyForDefine", OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = ClobAccessor.class.getDeclaredMethod("insertNull", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ClobAccessor.class.getDeclaredMethod("setCapacity", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

